/*  
/*  SAS Program for Scoring the All-Day Fruit & Vegetable Screener
/*  

/*  This code will read in a data file, and create intake and
/*  summary variables.  It DOES NOT correct entries, nor impute
/*  values for missing portion size variables;
/*
/*  Web Site:  riskfactor.cancer.gov/diet/screeners/



  PROC  FORMAT;

                VALUE $Q1____F
                  '0' = 'NEVER           '
                  '1' = '1 - 3 TIMES LAST'
                  '2' = '1 - 2 TIMES PER '
                  '3' = '3 - 4 TIMES PER '
                  '4' = '5 - 6 TIMES PER '
                  '5' = '1 TIME PER DAY  '
                  '6' = '2 TIMES PER DAY '
                  '7' = '3 TIMES PER DAY '
                  '8' = '4 TIMES PER DAY '
                  '9' = '5 OR MORE TIMES '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q1A___F
                  '0' = 'LESS THAN 3/4 CU'
                  '1' = '3/4 TO 1 1/4 CUP'
                  '2' = '1 1/4 TO 2 CUPS '
                  '3' = 'MORE THAN 2 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q2A1__F
                  '0' = 'LESS THAN 1 MEDI'
                  '1' = '1 MEDIUM FRUIT  '
                  '2' = '2 MEDIUM FRUITS '
                  '3' = 'MORE THAN 2 MEDI'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q2A2__F
                  '0' = 'LESS THAN 1/2 CU'
                  '1' = 'ABOUT 1/2 CUP   '
                  '2' = 'ABOUT 1 CUP     '
                  '3' = 'MORE THAN 1 CUP '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q3A___F
                  '0' = 'ABOUT 1/2 CUP   '
                  '1' = 'ABOUT 1 CUP     '
                  '2' = 'ABOUT 2 CUPS    '
                  '3' = 'MORE THAN 2 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q4A___F
                  '0' = 'SMALL ORDER OR L'
                  '1' = 'MEDIUM ORDER (AB'
                  '2' = 'LARGE ORDER (ABO'
                  '3' = 'SUPER SIZE ORDER'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q5A___F
                  '0' = '1 SMALL POTATO O'
                  '1' = '1 MEDIUM POTATO '
                  '2' = '1 LARGE POTATO ('
                  '3' = '2 MEDIUM POTATOE'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q6A___F
                  '0' = 'LESS THAN 1/2 CU'
                  '1' = '1/2 TO 1 CUP    '
                  '2' = '1 TO 1 1/2 CUPS '
                  '3' = 'MORE THAN 1 1/2 '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q7A___F
                  '0' = 'LESS THAN 1/2 CU'
                  '1' = '1/2 TO 1 CUP    '
                  '2' = '1 TO 2 CUPS     '
                  '3' = 'MORE THAN 2 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q8A___F
                  '0' = 'ABOUT 1/4 CUP   '
                  '1' = 'ABOUT 1/2 CUP   '
                  '2' = 'ABOUT 1 CUP     '
                  '3' = 'MORE THAN 1 CUP '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q9A___F
                  '0' = 'LESS THAN 1 CUP '
                  '1' = '1 TO 2 CUPS     '
                  '2' = '2 TO 3 CUPS     '
                  '3' = 'MORE THAN 3 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;

        *FORMAT

                Q1                $Q1____F.
                Q1A               $Q1A___F.
                Q2                $Q1____F.
                Q2A1              $Q2A1__F.
                Q2A2              $Q2A2__F.
                Q3                $Q1____F.
                Q3A               $Q3A___F.
                Q4                $Q1____F.
                Q4A               $Q4A___F.
                Q5                $Q1____F.
                Q5A               $Q5A___F.
                Q6                $Q1____F.
                Q6A               $Q6A___F.
                Q7                $Q1____F.
                Q7A               $Q7A___F.
                Q8                $Q1____F.
                Q8A               $Q8A___F.
                Q9                $Q1____F.
                Q9A               $Q9A___F.
                Q10               $Q1____F.
                ;


DATA SHORT;
  INFILE IN;

        INPUT

                APPL               $    0001-0003
                SER                $    0004-0009
                BAT                $    0010-0012
                SCNMM              $    0013-0014
                SCNDD              $    0015-0016
                SCNYY              $    0017-0018
                DOC                $    0019-0021
                EDIT               $    0022-0024
                FLAGS              $    0025-0040
                LITHO_ID           $    0041-0050
                WESID              $    0051-0060
                Q1                 $    0061
                Q1A                $    0062
                Q2                 $    0063
                Q2A1               $    0064
                Q2A2               $    0065
                Q3                 $    0066
                Q3A                $    0067
                Q4                 $    0068
                Q4A                $    0069
                Q5                 $    0070
                Q5A                $    0071
                Q6                 $    0072
                Q6A                $    0073
                Q7                 $    0074
                Q7A                $    0075
                Q8                 $    0076
                Q8A                $    0077
                Q9                 $    0078
                Q9A                $    0079
                Q10                $    0080
                ;



        LABEL

          APPL     = '-->APPLICATION NUMBER'
          SER      = '-->SERIAL NUMBER'
          BAT      = '-->BATCH NUMBER'
          SCNMM    = '-->SCANNED MONTH (MM)'
          SCNDD    = '-->SCANNED DAY (DD)'
          SCNYY    = '-->SCANNED YEAR (YY)'
          DOC      = '-->DOCUMENT NUMBER'
          EDIT     = '-->EDIT FLAGS'
          FLAGS    = '-->SCANNING FLAGS'
          LITHO_ID = '-->LITHOCODE ID NUMBER'
          WESID    = '-->STUDY/BARCODE ID NUMBER'
          Q1       = '-->OVER THE LAST MONTH, HOW MANY TIMES'
          Q1A      = '-->EACH TIME YOU DRANK 100% JUICE, HOW'
          Q2       = '-->OVER THE LAST MONTH, HOW MANY TIMES'
          Q2A1     = '-->EACH TIME YOU ATE FRUIT, HOW MUCH DID'
          Q2A2     = '-->EACH TIME YOU ATE FRUIT, HOW MUCH DID'
          Q3       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q3A      = '-->EACH TIME YOU ATE LETTUCE SALAD, HOW'
          Q4       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q4A      = '-->EACH TIME YOU ATE FRENCH FRIES OR'
          Q5       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q5A      = '-->EACH TIME YOU ATE THESE POTATOES, HOW'
          Q6       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q6A      = '-->EACH TIME YOU ATE THESE BEANS, HOW'
          Q7       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q7A      = '-->EACH TIME YOU ATE OTHER VEGETABLES,'
          Q8       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q8A      = '-->EACH TIME YOU ATE TOMATO SAUCE, HOW'
          Q9       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q9A      = '-->EACH TIME YOU ATE VEGETABLE SOUP, HOW'
          Q10      = '-->OVER THE LAST MONTH, HOW OFTEN DID'
        ;


DATA SHORT;
  SET SHORT;


  %MACRO FREQN (INC,OUTN);
   IF &INC='0' THEN &OUTN=0;
    ELSE IF &INC='1' THEN &OUTN=.067;
    ELSE IF &INC='2' THEN &OUTN=.214;
    ELSE IF &INC='3' THEN &OUTN=.5;
    ELSE IF &INC='4' THEN &OUTN=.786;
    ELSE IF &INC='5' THEN &OUTN=1;
    ELSE IF &INC='6' THEN &OUTN=2;
    ELSE IF &INC='7' THEN &OUTN=3;
    ELSE IF &INC='8' THEN &OUTN=4;
    ELSE IF &INC='9' THEN &OUTN=5;
  %MEND FREQN;

 %FREQN(Q1,Q1N);
  IF Q1A='0' THEN Q1AN=0.75;
    ELSE IF Q1A='1' THEN Q1AN=1.33;
    ELSE IF Q1A='2' THEN Q1AN=2.17;
    ELSE IF Q1A='3' THEN Q1AN=3.33;
    ELSE IF Q1N=0 THEN Q1AN=0;
  JUICE=Q1N*Q1AN;

 %FREQN(Q2,Q2N);
  IF Q2A1='0' THEN Q2A1N=0.75;
    ELSE IF Q2A1='1' THEN Q2A1N=1.0;
    ELSE IF Q2A1='2' THEN Q2A1N=2.0;
    ELSE IF Q2A1='3' THEN Q2A1N=2.5;
    ELSE IF Q2N=0 THEN Q2A1N=0;
  FRUITA=Q2N*Q2A1N;
  IF Q2A2='0' THEN Q2A2N=0.75;
    ELSE IF Q2A2='1' THEN Q2A2N=1.0;
    ELSE IF Q2A2='2' THEN Q2A2N=2.0;
    ELSE IF Q2A2='3' THEN Q2A2N=2.5;
    ELSE IF Q2N=0 THEN Q2A2N=0;
  FRUITB=Q2N*Q2A2N;
  FRUIT=MEAN(FRUITA,FRUITB);

 %FREQN(Q3,Q3N);
  IF Q3A='0' THEN Q3AN=0.5;
    ELSE IF Q3A='1' THEN Q3AN=1.0;
    ELSE IF Q3A='2' THEN Q3AN=2.0;
    ELSE IF Q3A='3' THEN Q3AN=3.0;
    ELSE IF Q3N=0 THEN Q3AN=0;
  LSALAD=Q3N*Q3AN;

 %FREQN(Q4,Q4N);
  IF Q4A='0' THEN Q4AN=1.25;
    ELSE IF Q4A='1' THEN Q4AN=2.3;
    ELSE IF Q4A='2' THEN Q4AN=3.1;
    ELSE IF Q4A='3' THEN Q4AN=4.8;
    ELSE IF Q4N=0 THEN Q4AN=0;
  FRFRY=Q4N*Q4AN;

 %FREQN(Q5,Q5N);
  IF Q5A='0' THEN Q5AN=0.80;
    ELSE IF Q5A='1' THEN Q5AN=1.5;
    ELSE IF Q5A='2' THEN Q5AN=2.4;
    ELSE IF Q5A='3' THEN Q5AN=3.5;
    ELSE IF Q5N=0 THEN Q5AN=0;
  WHPOT=Q5N*Q5AN;

 %FREQN(Q6,Q6N);
  IF Q6A='0' THEN Q6AN=0.75;
    ELSE IF Q6A='1' THEN Q6AN=1.5;
    ELSE IF Q6A='2' THEN Q6AN=2.5;
    ELSE IF Q6A='3' THEN Q6AN=3.5;
    ELSE IF Q6N=0 THEN Q6AN=0;
  DRBEAN=Q6N*Q6AN;

 %FREQN(Q7,Q7N);
  IF Q7A='0' THEN Q7AN=0.75;
    ELSE IF Q7A='1' THEN Q7AN=1.5;
    ELSE IF Q7A='2' THEN Q7AN=3.0;
    ELSE IF Q7A='3' THEN Q7AN=4.5;
    ELSE IF Q7N=0 THEN Q7AN=0;
  OTHVEG=Q7N*Q7AN;

 %FREQN(Q8,Q8N);
  IF Q8A='0' THEN Q8AN=0.36;
    ELSE IF Q8A='1' THEN Q8AN=0.72;
    ELSE IF Q8A='2' THEN Q8AN=1.45;
    ELSE IF Q8A='3' THEN Q8AN=1.7;
    ELSE IF Q8N=0 THEN Q8AN=0;
  TOMSAUCE=Q8N*Q8AN;

 %FREQN(Q9,Q9N);
  IF Q9A='0' THEN Q9AN=0.75;
    ELSE IF Q9A='1' THEN Q9AN=1.36;
    ELSE IF Q9A='2' THEN Q9AN=2.27;
    ELSE IF Q9A='3' THEN Q9AN=3.2;
    ELSE IF Q9N=0 THEN Q9AN=0;
  VEGSOUP=Q9N*Q9AN;

  FRTVEG=SUM(JUICE,FRUIT,LSALAD,FRFRY,WHPOT,DRBEAN,OTHVEG,TOMSAUCE,
    VEGSOUP);
